package drr.regulation.common.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ClearingExceptionReason;
import drr.regulation.common.ClearingExceptionReasonEnum;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ClearingExceptionReasonValidator implements Validator<ClearingExceptionReason> {

	private List<ComparisonResult> getComparisonResults(ClearingExceptionReason o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("exceptionReason", (ClearingExceptionReasonEnum) o.getExceptionReason() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ClearingExceptionReason o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ClearingExceptionReason", ValidationResult.ValidationType.CARDINALITY, "ClearingExceptionReason", path, "", res.getError());
				}
				return success("ClearingExceptionReason", ValidationResult.ValidationType.CARDINALITY, "ClearingExceptionReason", path, "");
			})
			.collect(toList());
	}

}
