package drr.regulation.common.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.esma.emir.refit.trade.PriceAndNotation;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class PriceReportablePeriodValidator implements Validator<PriceReportablePeriod> {

	private List<ComparisonResult> getComparisonResults(PriceReportablePeriod o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("periodValue", (PriceAndNotation) o.getPeriodValue() != null ? 1 : 0, 1, 1), 
				checkCardinality("periodEffectiveDate", (Date) o.getPeriodEffectiveDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("periodEndDate", (Date) o.getPeriodEndDate() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceReportablePeriod o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("PriceReportablePeriod", ValidationResult.ValidationType.CARDINALITY, "PriceReportablePeriod", path, "", res.getError());
				}
				return success("PriceReportablePeriod", ValidationResult.ValidationType.CARDINALITY, "PriceReportablePeriod", path, "");
			})
			.collect(toList());
	}

}
