package drr.regulation.common.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.ClearingExceptionReason;
import drr.regulation.common.ClearingExceptionReasonEnum;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class ClearingExceptionReasonOnlyExistsValidator implements ValidatorWithArg<ClearingExceptionReason, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends ClearingExceptionReason> ValidationResult<ClearingExceptionReason> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("exceptionReason", ExistenceChecker.isSet((ClearingExceptionReasonEnum) o.getExceptionReason()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("ClearingExceptionReason", ValidationResult.ValidationType.ONLY_EXISTS, "ClearingExceptionReason", path, "");
		}
		return failure("ClearingExceptionReason", ValidationResult.ValidationType.ONLY_EXISTS, "ClearingExceptionReason", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
