package drr.regulation.esma.emir.refit.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralDetails;
import drr.regulation.common.CollateralReportInstruction;
import iso20022.auth108.esma.CollateralisationType3Code__1;


@ImplementedBy(CollateralisationCategoryRule.CollateralisationCategoryRuleDefault.class)
public abstract class CollateralisationCategoryRule implements ReportFunction<CollateralReportInstruction, CollateralisationType3Code__1> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CollateralisationType3Code__1 evaluate(CollateralReportInstruction input) {
		CollateralisationType3Code__1 output = doEvaluate(input);
		
		return output;
	}

	protected abstract CollateralisationType3Code__1 doEvaluate(CollateralReportInstruction input);

	public static class CollateralisationCategoryRuleDefault extends CollateralisationCategoryRule {
		@Override
		protected CollateralisationType3Code__1 doEvaluate(CollateralReportInstruction input) {
			CollateralisationType3Code__1 output = null;
			return assignOutput(output, input);
		}
		
		protected CollateralisationType3Code__1 assignOutput(CollateralisationType3Code__1 output, CollateralReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> item.<CollateralDetails>map("getCollateralDetails", collateralReportInstruction -> collateralReportInstruction.getCollateralDetails()).<CollateralisationType3Code__1>map("getCollateralisationCategory", collateralDetails -> collateralDetails.getCollateralisationCategory())).get();
			
			return output;
		}
	}
}
