package drr.regulation.esma.emir.refit.margin.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.esma.emir.refit.margin.ESMAEMIRMarginReport;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ESMAEMIRMarginReportTypeFormatValidator implements Validator<ESMAEMIRMarginReport> {

	private List<ComparisonResult> getComparisonResults(ESMAEMIRMarginReport o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRMarginReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ESMAEMIRMarginReport", ValidationResult.ValidationType.TYPE_FORMAT, "ESMAEMIRMarginReport", path, "", res.getError());
				}
				return success("ESMAEMIRMarginReport", ValidationResult.ValidationType.TYPE_FORMAT, "ESMAEMIRMarginReport", path, "");
			})
			.collect(toList());
	}

}
