package drr.regulation.esma.emir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Create_ContinuousQuantitySchedule;
import drr.regulation.common.functions.GetExpirationDate;
import drr.regulation.common.functions.GetReportableQuantityPeriodLeg1;
import drr.regulation.common.functions.TradeForEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(EUEMIRReportableQuantityPeriodLeg1.EUEMIRReportableQuantityPeriodLeg1Default.class)
public abstract class EUEMIRReportableQuantityPeriodLeg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_ContinuousQuantitySchedule create_ContinuousQuantitySchedule;
	@Inject protected GetExpirationDate getExpirationDate;
	@Inject protected GetReportableQuantityPeriodLeg1 getReportableQuantityPeriodLeg1;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param transactionReportInstruction 
	* @return emirReportableQuantityPeriods 
	*/
	public List<? extends QuantityReportablePeriod> evaluate(TransactionReportInstruction transactionReportInstruction) {
		List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> emirReportableQuantityPeriodsBuilder = doEvaluate(transactionReportInstruction);
		
		final List<? extends QuantityReportablePeriod> emirReportableQuantityPeriods;
		if (emirReportableQuantityPeriodsBuilder == null) {
			emirReportableQuantityPeriods = null;
		} else {
			emirReportableQuantityPeriods = emirReportableQuantityPeriodsBuilder.stream().map(QuantityReportablePeriod::build).collect(Collectors.toList());
			objectValidator.validate(QuantityReportablePeriod.class, emirReportableQuantityPeriods);
		}
		
		return emirReportableQuantityPeriods;
	}

	protected abstract List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<Date> expirationDate(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperC<? extends QuantityReportablePeriod> genericReportableQuantitySchedule(TransactionReportInstruction transactionReportInstruction);

	public static class EUEMIRReportableQuantityPeriodLeg1Default extends EUEMIRReportableQuantityPeriodLeg1 {
		@Override
		protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction) {
			List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> emirReportableQuantityPeriods = new ArrayList<>();
			return assignOutput(emirReportableQuantityPeriods, transactionReportInstruction);
		}
		
		protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> assignOutput(List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> emirReportableQuantityPeriods, TransactionReportInstruction transactionReportInstruction) {
			emirReportableQuantityPeriods = toBuilder(create_ContinuousQuantitySchedule.evaluate(genericReportableQuantitySchedule(transactionReportInstruction).getMulti(), expirationDate(transactionReportInstruction).get()));
			
			return Optional.ofNullable(emirReportableQuantityPeriods)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
		
		@Override
		protected MapperS<Date> expirationDate(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(getExpirationDate.evaluate(transactionReportInstruction));
		}
		
		@Override
		protected MapperC<? extends QuantityReportablePeriod> genericReportableQuantitySchedule(TransactionReportInstruction transactionReportInstruction) {
			return MapperC.<QuantityReportablePeriod>of(getReportableQuantityPeriodLeg1.evaluate(tradeForEvent.evaluate(transactionReportInstruction)));
		}
	}
}
