package drr.regulation.esma.emir.refit.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRNonReportable;
import drr.regulation.esma.emir.refit.trade.validation.ESMAEMIRNonReportableTypeFormatValidator;
import drr.regulation.esma.emir.refit.trade.validation.ESMAEMIRNonReportableValidator;
import drr.regulation.esma.emir.refit.trade.validation.exists.ESMAEMIRNonReportableOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.50.0
 */
@RosettaMeta(model=ESMAEMIRNonReportable.class)
public class ESMAEMIRNonReportableMeta implements RosettaMetaData<ESMAEMIRNonReportable> {

	@Override
	public List<Validator<? super ESMAEMIRNonReportable>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super ESMAEMIRNonReportable, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super ESMAEMIRNonReportable> validator(ValidatorFactory factory) {
		return factory.<ESMAEMIRNonReportable>create(ESMAEMIRNonReportableValidator.class);
	}

	@Override
	public Validator<? super ESMAEMIRNonReportable> typeFormatValidator(ValidatorFactory factory) {
		return factory.<ESMAEMIRNonReportable>create(ESMAEMIRNonReportableTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super ESMAEMIRNonReportable> validator() {
		return new ESMAEMIRNonReportableValidator();
	}

	@Deprecated
	@Override
	public Validator<? super ESMAEMIRNonReportable> typeFormatValidator() {
		return new ESMAEMIRNonReportableTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super ESMAEMIRNonReportable, Set<String>> onlyExistsValidator() {
		return new ESMAEMIRNonReportableOnlyExistsValidator();
	}
}
