package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.datetime.Period;
import cdm.base.datetime.PeriodEnum;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.AdjustPeriodMultiplier;
import drr.regulation.common.functions.FloatingReferencePeriod;
import drr.regulation.common.functions.FormatToMax3Number;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsFRA;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.common.functions.RateOption;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FloatingRateReferencePeriodOfLeg1MultiplierRule.FloatingRateReferencePeriodOfLeg1MultiplierRuleDefault.class)
public abstract class FloatingRateReferencePeriodOfLeg1MultiplierRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected AdjustPeriodMultiplier adjustPeriodMultiplier;
	@Inject protected FloatingReferencePeriod floatingReferencePeriod;
	@Inject protected FormatToMax3Number formatToMax3Number;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsFRA isFRA;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;
	@Inject protected RateOption rateOption;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class FloatingRateReferencePeriodOfLeg1MultiplierRuleDefault extends FloatingRateReferencePeriodOfLeg1MultiplierRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(reportInstruction -> {
					final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
						.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
					final MapperS<Product> thenArg1 = thenArg0
						.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
					final MapperS<Product> thenArg2 = thenArg1
						.filterSingleNullSafe(item -> areEqual(MapperS.of(isFRA.evaluate(item.get())), MapperS.of(false), CardinalityOperator.All).get());
					final MapperS<Product> thenArg3 = thenArg2
						.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
					final MapperS<InterestRatePayout> thenArg4 = thenArg3
						.mapSingleToItem(item -> MapperS.of(interestRateLeg1.evaluate(item.get())));
					final MapperS<BigDecimal> thenArg5 = thenArg4
						.mapSingleToItem(item -> {
							final MapperS<PeriodEnum> thenArg = MapperS.of(rateOption.evaluate(item.get())).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<PeriodEnum>map("getPeriod", period -> period.getPeriod());
							final Integer integer = MapperS.of(rateOption.evaluate(item.get())).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<Integer>map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).get();
							return MapperS.of(adjustPeriodMultiplier.evaluate(thenArg
								.mapSingleToItem(_item -> MapperS.of(floatingReferencePeriod.evaluate(_item.get()))).get(), (integer == null ? null : BigDecimal.valueOf(integer))));
						});
					return MapperS.of(formatToMax3Number.evaluate(thenArg5.get()));
				}).get();
			
			return output;
		}
	}
}
