package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsCapFloor;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.reports.CDEOptionPremiumPaymentDateRule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(OptionPremiumPaymentDateRule.OptionPremiumPaymentDateRuleDefault.class)
public abstract class OptionPremiumPaymentDateRule implements ReportFunction<TransactionReportInstruction, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEOptionPremiumPaymentDateRule cDEOptionPremiumPaymentDateRule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected IsCapFloor isCapFloor;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(TransactionReportInstruction input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(TransactionReportInstruction input);

	public static class OptionPremiumPaymentDateRuleDefault extends OptionPremiumPaymentDateRule {
		@Override
		protected Date doEvaluate(TransactionReportInstruction input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, TransactionReportInstruction input) {
			if (exists(MapperS.of(cDEOptionPremiumPaymentDateRule.evaluate(input))).getOrDefault(false)) {
				output = cDEOptionPremiumPaymentDateRule.evaluate(input);
			} else {
				final Boolean _boolean = isCapFloor.evaluate(productForEvent.evaluate(input));
				if ((_boolean == null ? false : _boolean)) {
					output = effectiveDateRule.evaluate(input);
				} else {
					output = null;
				}
			}
			
			return output;
		}
	}
}
