package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.IsOtherPayment;
import drr.standards.iosco.cde.reports.CDEOtherPaymentCurrencyRule;
import javax.inject.Inject;


@ImplementedBy(OtherPaymentCurrencyRule.OtherPaymentCurrencyRuleDefault.class)
public abstract class OtherPaymentCurrencyRule implements ReportFunction<TransferState, ISOCurrencyCodeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEOtherPaymentCurrencyRule cDEOtherPaymentCurrencyRule;
	@Inject protected IsOtherPayment isOtherPayment;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ISOCurrencyCodeEnum evaluate(TransferState input) {
		ISOCurrencyCodeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ISOCurrencyCodeEnum doEvaluate(TransferState input);

	public static class OtherPaymentCurrencyRuleDefault extends OtherPaymentCurrencyRule {
		@Override
		protected ISOCurrencyCodeEnum doEvaluate(TransferState input) {
			ISOCurrencyCodeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransferState input) {
			final MapperS<TransferState> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isOtherPayment.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(cDEOtherPaymentCurrencyRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
