package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.base.staticdata.party.RelatedParty;
import cdm.base.staticdata.party.functions.FilterPartyRole;
import cdm.base.staticdata.party.functions.FilterRelatedPartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.BusinessEvent;
import cdm.event.common.ExecutionInstruction;
import cdm.event.common.Instruction;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsActionTypeCORR;
import drr.regulation.common.functions.IsActionTypeMODI;
import drr.regulation.common.functions.IsActionTypeNEWT;
import drr.regulation.common.functions.IsActionTypeREVI;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsCompressed;
import drr.regulation.common.functions.IsPortfolioRebalancing;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PTRRIDRule.PTRRIDRuleDefault.class)
public abstract class PTRRIDRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FilterPartyRole filterPartyRole;
	@Inject protected FilterRelatedPartyByRole filterRelatedPartyByRole;
	@Inject protected IsActionTypeCORR isActionTypeCORR;
	@Inject protected IsActionTypeMODI isActionTypeMODI;
	@Inject protected IsActionTypeNEWT isActionTypeNEWT;
	@Inject protected IsActionTypeREVI isActionTypeREVI;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected IsCompressed isCompressed;
	@Inject protected IsPortfolioRebalancing isPortfolioRebalancing;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class PTRRIDRuleDefault extends PTRRIDRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> ComparisonResult.of(MapperS.of(isActionTypeNEWT.evaluate(item.get()))).or(ComparisonResult.of(MapperS.of(isActionTypeMODI.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isActionTypeCORR.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isActionTypeTERM.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isActionTypeREVI.evaluate(item.get())))).get());
			final MapperC<FieldWithMetaString> thenArg1 = thenArg0
				.mapSingleToList(reportableEvent -> {
					final MapperC<Identifier> _thenArg0 = reportableEvent.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).<Identifier>mapC("getEventIdentifier", workflowStep -> workflowStep.getEventIdentifier());
					final MapperListOfLists<FieldWithMetaString> _thenArg1 = _thenArg0
						.mapItemToList(eventIdentifier -> {
							final MapperS<Identifier> thenArg = eventIdentifier
								.filterSingleNullSafe(item -> {
									if (ComparisonResult.of(MapperS.of(isCompressed.evaluate(reportableEvent.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get()))).or(ComparisonResult.of(MapperS.of(isPortfolioRebalancing.evaluate(reportableEvent.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get())))).getOrDefault(false)) {
										if (exists(reportableEvent.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<Instruction>mapC("getInstruction", businessEvent -> businessEvent.getInstruction()).<PrimitiveInstruction>map("getPrimitiveInstruction", instruction -> instruction.getPrimitiveInstruction()).<ExecutionInstruction>map("getExecution", primitiveInstruction -> primitiveInstruction.getExecution())).getOrDefault(false)) {
											final ReferenceWithMetaParty referenceWithMetaParty1 = distinct(MapperC.<PartyRole>of(filterPartyRole.evaluate(reportableEvent.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<Instruction>mapC("getInstruction", businessEvent -> businessEvent.getInstruction()).<PrimitiveInstruction>map("getPrimitiveInstruction", instruction -> instruction.getPrimitiveInstruction()).<ExecutionInstruction>map("getExecution", primitiveInstruction -> primitiveInstruction.getExecution()).<PartyRole>mapC("getPartyRoles", executionInstruction -> executionInstruction.getPartyRoles()).getMulti(), PartyRoleEnum.PTRR_SERVICE_PROVIDER)).<ReferenceWithMetaParty>map("getPartyReference", partyRole -> partyRole.getPartyReference())).get();
											return areEqual(item.<ReferenceWithMetaParty>map("getIssuerReference", identifier -> identifier.getIssuerReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()), (referenceWithMetaParty1 == null ? MapperS.<Party>ofNull() : MapperS.of(referenceWithMetaParty1.getValue())), CardinalityOperator.All).get();
										}
										final ReferenceWithMetaParty referenceWithMetaParty3 = distinct(MapperC.<RelatedParty>of(filterRelatedPartyByRole.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<RelatedParty>mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.PTRR_SERVICE_PROVIDER)).<ReferenceWithMetaParty>map("getPartyReference", relatedParty -> relatedParty.getPartyReference())).get();
										return areEqual(item.<ReferenceWithMetaParty>map("getIssuerReference", identifier -> identifier.getIssuerReference()).<Party>map("Type coercion", referenceWithMetaParty2 -> referenceWithMetaParty2 == null ? null : referenceWithMetaParty2.getValue()), (referenceWithMetaParty3 == null ? MapperS.<Party>ofNull() : MapperS.of(referenceWithMetaParty3.getValue())), CardinalityOperator.All).get();
									}
									return null;
								});
							return thenArg
								.mapSingleToList(item -> eventIdentifier.<AssignedIdentifier>mapC("getAssignedIdentifier", identifier -> identifier.getAssignedIdentifier()).<FieldWithMetaString>map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()));
						});
					return _thenArg1
						.flattenList();
				});
			final FieldWithMetaString fieldWithMetaString = MapperS.of(thenArg1.get()).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
