package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableDelivery;
import drr.regulation.common.functions.FormatToLongFraction20DecimalNumber;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(PriceTimeIntervalQuantityRule.PriceTimeIntervalQuantityRuleDefault.class)
public abstract class PriceTimeIntervalQuantityRule implements ReportFunction<ReportableDelivery, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FormatToLongFraction20DecimalNumber formatToLongFraction20DecimalNumber;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(ReportableDelivery input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(ReportableDelivery input);

	public static class PriceTimeIntervalQuantityRuleDefault extends PriceTimeIntervalQuantityRule {
		@Override
		protected BigDecimal doEvaluate(ReportableDelivery input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, ReportableDelivery input) {
			final MapperS<BigDecimal> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> item.<BigDecimal>map("getPriceTimeIntervalQuantity", reportableDelivery -> reportableDelivery.getPriceTimeIntervalQuantity()));
			output = MapperS.of(formatToLongFraction20DecimalNumber.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
