package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.regulation.esma.emir.refit.trade.NotionalQuantityScheduleLeg1Report;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("ESMAEMIRTransactionReportEMIR_VR_2061_01")
@ImplementedBy(ESMAEMIRTransactionReportEMIR_VR_2061_01.Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2061_01 extends Validator<ESMAEMIRTransactionReport> {
	
	String NAME = "ESMAEMIRTransactionReportEMIR_VR_2061_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then (notionalQuantityScheduleLeg1 extract (if value exists then effectiveDate exists else effectiveDate is absent) then all = True)";
	
	class Default implements ESMAEMIRTransactionReportEMIR_VR_2061_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					final MapperC<Boolean> thenArg = MapperS.of(eSMAEMIRTransactionReport).<NotionalQuantityScheduleLeg1Report>mapC("getNotionalQuantityScheduleLeg1", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getNotionalQuantityScheduleLeg1())
						.mapItem(item -> {
							if (exists(item.<BigDecimal>map("getValue", notionalQuantityScheduleLeg1Report -> notionalQuantityScheduleLeg1Report.getValue())).getOrDefault(false)) {
								return exists(item.<Date>map("getEffectiveDate", notionalQuantityScheduleLeg1Report -> notionalQuantityScheduleLeg1Report.getEffectiveDate())).asMapper();
							}
							return notExists(item.<Date>map("getEffectiveDate", notionalQuantityScheduleLeg1Report -> notionalQuantityScheduleLeg1Report.getEffectiveDate())).asMapper();
						});
					return ComparisonResult.of(areEqual(thenArg, MapperS.of(true), CardinalityOperator.All).asMapper());
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRTransactionReportEMIR_VR_2061_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
