package drr.regulation.fca.ukemir.refit.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.fca.ukemir.refit.trade.meta.SpreadOfLeg2Meta;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.50.0
 */
@RosettaDataType(value="SpreadOfLeg2", builder=SpreadOfLeg2.SpreadOfLeg2BuilderImpl.class, version="5.50.0")
@RuneDataType(value="SpreadOfLeg2", model="drr", builder=SpreadOfLeg2.SpreadOfLeg2BuilderImpl.class, version="5.50.0")
public interface SpreadOfLeg2 extends RosettaModelObject {

	SpreadOfLeg2Meta metaData = new SpreadOfLeg2Meta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getSpreadOfLeg2Monetary();
	BigDecimal getSpreadOfLeg2Percentage();
	BigDecimal getSpreadOfLeg2Basis();
	String getSpreadCurrencyOfLeg2();
	PriceNotationEnum getSpreadOfLeg2Notation();

	/*********************** Build Methods  ***********************/
	SpreadOfLeg2 build();
	
	SpreadOfLeg2.SpreadOfLeg2Builder toBuilder();
	
	static SpreadOfLeg2.SpreadOfLeg2Builder builder() {
		return new SpreadOfLeg2.SpreadOfLeg2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends SpreadOfLeg2> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends SpreadOfLeg2> getType() {
		return SpreadOfLeg2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("spreadOfLeg2Monetary"), BigDecimal.class, getSpreadOfLeg2Monetary(), this);
		processor.processBasic(path.newSubPath("spreadOfLeg2Percentage"), BigDecimal.class, getSpreadOfLeg2Percentage(), this);
		processor.processBasic(path.newSubPath("spreadOfLeg2Basis"), BigDecimal.class, getSpreadOfLeg2Basis(), this);
		processor.processBasic(path.newSubPath("spreadCurrencyOfLeg2"), String.class, getSpreadCurrencyOfLeg2(), this);
		processor.processBasic(path.newSubPath("spreadOfLeg2Notation"), PriceNotationEnum.class, getSpreadOfLeg2Notation(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface SpreadOfLeg2Builder extends SpreadOfLeg2, RosettaModelObjectBuilder {
		SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Monetary(BigDecimal spreadOfLeg2Monetary);
		SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Percentage(BigDecimal spreadOfLeg2Percentage);
		SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Basis(BigDecimal spreadOfLeg2Basis);
		SpreadOfLeg2.SpreadOfLeg2Builder setSpreadCurrencyOfLeg2(String spreadCurrencyOfLeg2);
		SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Notation(PriceNotationEnum spreadOfLeg2Notation);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("spreadOfLeg2Monetary"), BigDecimal.class, getSpreadOfLeg2Monetary(), this);
			processor.processBasic(path.newSubPath("spreadOfLeg2Percentage"), BigDecimal.class, getSpreadOfLeg2Percentage(), this);
			processor.processBasic(path.newSubPath("spreadOfLeg2Basis"), BigDecimal.class, getSpreadOfLeg2Basis(), this);
			processor.processBasic(path.newSubPath("spreadCurrencyOfLeg2"), String.class, getSpreadCurrencyOfLeg2(), this);
			processor.processBasic(path.newSubPath("spreadOfLeg2Notation"), PriceNotationEnum.class, getSpreadOfLeg2Notation(), this);
		}
		

		SpreadOfLeg2.SpreadOfLeg2Builder prune();
	}

	/*********************** Immutable Implementation of SpreadOfLeg2  ***********************/
	class SpreadOfLeg2Impl implements SpreadOfLeg2 {
		private final BigDecimal spreadOfLeg2Monetary;
		private final BigDecimal spreadOfLeg2Percentage;
		private final BigDecimal spreadOfLeg2Basis;
		private final String spreadCurrencyOfLeg2;
		private final PriceNotationEnum spreadOfLeg2Notation;
		
		protected SpreadOfLeg2Impl(SpreadOfLeg2.SpreadOfLeg2Builder builder) {
			this.spreadOfLeg2Monetary = builder.getSpreadOfLeg2Monetary();
			this.spreadOfLeg2Percentage = builder.getSpreadOfLeg2Percentage();
			this.spreadOfLeg2Basis = builder.getSpreadOfLeg2Basis();
			this.spreadCurrencyOfLeg2 = builder.getSpreadCurrencyOfLeg2();
			this.spreadOfLeg2Notation = builder.getSpreadOfLeg2Notation();
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2Monetary")
		@RuneAttribute("spreadOfLeg2Monetary")
		public BigDecimal getSpreadOfLeg2Monetary() {
			return spreadOfLeg2Monetary;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2Percentage")
		@RuneAttribute("spreadOfLeg2Percentage")
		public BigDecimal getSpreadOfLeg2Percentage() {
			return spreadOfLeg2Percentage;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2Basis")
		@RuneAttribute("spreadOfLeg2Basis")
		public BigDecimal getSpreadOfLeg2Basis() {
			return spreadOfLeg2Basis;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyOfLeg2")
		@RuneAttribute("spreadCurrencyOfLeg2")
		public String getSpreadCurrencyOfLeg2() {
			return spreadCurrencyOfLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2Notation")
		@RuneAttribute("spreadOfLeg2Notation")
		public PriceNotationEnum getSpreadOfLeg2Notation() {
			return spreadOfLeg2Notation;
		}
		
		@Override
		public SpreadOfLeg2 build() {
			return this;
		}
		
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder toBuilder() {
			SpreadOfLeg2.SpreadOfLeg2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(SpreadOfLeg2.SpreadOfLeg2Builder builder) {
			ofNullable(getSpreadOfLeg2Monetary()).ifPresent(builder::setSpreadOfLeg2Monetary);
			ofNullable(getSpreadOfLeg2Percentage()).ifPresent(builder::setSpreadOfLeg2Percentage);
			ofNullable(getSpreadOfLeg2Basis()).ifPresent(builder::setSpreadOfLeg2Basis);
			ofNullable(getSpreadCurrencyOfLeg2()).ifPresent(builder::setSpreadCurrencyOfLeg2);
			ofNullable(getSpreadOfLeg2Notation()).ifPresent(builder::setSpreadOfLeg2Notation);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SpreadOfLeg2 _that = getType().cast(o);
		
			if (!Objects.equals(spreadOfLeg2Monetary, _that.getSpreadOfLeg2Monetary())) return false;
			if (!Objects.equals(spreadOfLeg2Percentage, _that.getSpreadOfLeg2Percentage())) return false;
			if (!Objects.equals(spreadOfLeg2Basis, _that.getSpreadOfLeg2Basis())) return false;
			if (!Objects.equals(spreadCurrencyOfLeg2, _that.getSpreadCurrencyOfLeg2())) return false;
			if (!Objects.equals(spreadOfLeg2Notation, _that.getSpreadOfLeg2Notation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (spreadOfLeg2Monetary != null ? spreadOfLeg2Monetary.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2Percentage != null ? spreadOfLeg2Percentage.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2Basis != null ? spreadOfLeg2Basis.hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyOfLeg2 != null ? spreadCurrencyOfLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2Notation != null ? spreadOfLeg2Notation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SpreadOfLeg2 {" +
				"spreadOfLeg2Monetary=" + this.spreadOfLeg2Monetary + ", " +
				"spreadOfLeg2Percentage=" + this.spreadOfLeg2Percentage + ", " +
				"spreadOfLeg2Basis=" + this.spreadOfLeg2Basis + ", " +
				"spreadCurrencyOfLeg2=" + this.spreadCurrencyOfLeg2 + ", " +
				"spreadOfLeg2Notation=" + this.spreadOfLeg2Notation +
			'}';
		}
	}

	/*********************** Builder Implementation of SpreadOfLeg2  ***********************/
	class SpreadOfLeg2BuilderImpl implements SpreadOfLeg2.SpreadOfLeg2Builder {
	
		protected BigDecimal spreadOfLeg2Monetary;
		protected BigDecimal spreadOfLeg2Percentage;
		protected BigDecimal spreadOfLeg2Basis;
		protected String spreadCurrencyOfLeg2;
		protected PriceNotationEnum spreadOfLeg2Notation;
		
		@Override
		@RosettaAttribute("spreadOfLeg2Monetary")
		@RuneAttribute("spreadOfLeg2Monetary")
		public BigDecimal getSpreadOfLeg2Monetary() {
			return spreadOfLeg2Monetary;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2Percentage")
		@RuneAttribute("spreadOfLeg2Percentage")
		public BigDecimal getSpreadOfLeg2Percentage() {
			return spreadOfLeg2Percentage;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2Basis")
		@RuneAttribute("spreadOfLeg2Basis")
		public BigDecimal getSpreadOfLeg2Basis() {
			return spreadOfLeg2Basis;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyOfLeg2")
		@RuneAttribute("spreadCurrencyOfLeg2")
		public String getSpreadCurrencyOfLeg2() {
			return spreadCurrencyOfLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2Notation")
		@RuneAttribute("spreadOfLeg2Notation")
		public PriceNotationEnum getSpreadOfLeg2Notation() {
			return spreadOfLeg2Notation;
		}
		
		@RosettaAttribute("spreadOfLeg2Monetary")
		@RuneAttribute("spreadOfLeg2Monetary")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Monetary(BigDecimal _spreadOfLeg2Monetary) {
			this.spreadOfLeg2Monetary = _spreadOfLeg2Monetary == null ? null : _spreadOfLeg2Monetary;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg2Percentage")
		@RuneAttribute("spreadOfLeg2Percentage")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Percentage(BigDecimal _spreadOfLeg2Percentage) {
			this.spreadOfLeg2Percentage = _spreadOfLeg2Percentage == null ? null : _spreadOfLeg2Percentage;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg2Basis")
		@RuneAttribute("spreadOfLeg2Basis")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Basis(BigDecimal _spreadOfLeg2Basis) {
			this.spreadOfLeg2Basis = _spreadOfLeg2Basis == null ? null : _spreadOfLeg2Basis;
			return this;
		}
		
		@RosettaAttribute("spreadCurrencyOfLeg2")
		@RuneAttribute("spreadCurrencyOfLeg2")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder setSpreadCurrencyOfLeg2(String _spreadCurrencyOfLeg2) {
			this.spreadCurrencyOfLeg2 = _spreadCurrencyOfLeg2 == null ? null : _spreadCurrencyOfLeg2;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg2Notation")
		@RuneAttribute("spreadOfLeg2Notation")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Notation(PriceNotationEnum _spreadOfLeg2Notation) {
			this.spreadOfLeg2Notation = _spreadOfLeg2Notation == null ? null : _spreadOfLeg2Notation;
			return this;
		}
		
		@Override
		public SpreadOfLeg2 build() {
			return new SpreadOfLeg2.SpreadOfLeg2Impl(this);
		}
		
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getSpreadOfLeg2Monetary()!=null) return true;
			if (getSpreadOfLeg2Percentage()!=null) return true;
			if (getSpreadOfLeg2Basis()!=null) return true;
			if (getSpreadCurrencyOfLeg2()!=null) return true;
			if (getSpreadOfLeg2Notation()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			SpreadOfLeg2.SpreadOfLeg2Builder o = (SpreadOfLeg2.SpreadOfLeg2Builder) other;
			
			
			merger.mergeBasic(getSpreadOfLeg2Monetary(), o.getSpreadOfLeg2Monetary(), this::setSpreadOfLeg2Monetary);
			merger.mergeBasic(getSpreadOfLeg2Percentage(), o.getSpreadOfLeg2Percentage(), this::setSpreadOfLeg2Percentage);
			merger.mergeBasic(getSpreadOfLeg2Basis(), o.getSpreadOfLeg2Basis(), this::setSpreadOfLeg2Basis);
			merger.mergeBasic(getSpreadCurrencyOfLeg2(), o.getSpreadCurrencyOfLeg2(), this::setSpreadCurrencyOfLeg2);
			merger.mergeBasic(getSpreadOfLeg2Notation(), o.getSpreadOfLeg2Notation(), this::setSpreadOfLeg2Notation);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SpreadOfLeg2 _that = getType().cast(o);
		
			if (!Objects.equals(spreadOfLeg2Monetary, _that.getSpreadOfLeg2Monetary())) return false;
			if (!Objects.equals(spreadOfLeg2Percentage, _that.getSpreadOfLeg2Percentage())) return false;
			if (!Objects.equals(spreadOfLeg2Basis, _that.getSpreadOfLeg2Basis())) return false;
			if (!Objects.equals(spreadCurrencyOfLeg2, _that.getSpreadCurrencyOfLeg2())) return false;
			if (!Objects.equals(spreadOfLeg2Notation, _that.getSpreadOfLeg2Notation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (spreadOfLeg2Monetary != null ? spreadOfLeg2Monetary.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2Percentage != null ? spreadOfLeg2Percentage.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2Basis != null ? spreadOfLeg2Basis.hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyOfLeg2 != null ? spreadCurrencyOfLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2Notation != null ? spreadOfLeg2Notation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SpreadOfLeg2Builder {" +
				"spreadOfLeg2Monetary=" + this.spreadOfLeg2Monetary + ", " +
				"spreadOfLeg2Percentage=" + this.spreadOfLeg2Percentage + ", " +
				"spreadOfLeg2Basis=" + this.spreadOfLeg2Basis + ", " +
				"spreadCurrencyOfLeg2=" + this.spreadCurrencyOfLeg2 + ", " +
				"spreadOfLeg2Notation=" + this.spreadOfLeg2Notation +
			'}';
		}
	}
}
