package drr.regulation.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Create_ContinuousPriceSchedule;
import drr.regulation.common.functions.GetExpirationDate;
import drr.regulation.common.functions.GetReportablePricePeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(UKEMIRReportablePricePeriod.UKEMIRReportablePricePeriodDefault.class)
public abstract class UKEMIRReportablePricePeriod implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_ContinuousPriceSchedule create_ContinuousPriceSchedule;
	@Inject protected GetExpirationDate getExpirationDate;
	@Inject protected GetReportablePricePeriod getReportablePricePeriod;

	/**
	* @param transactionReportInstruction 
	* @return emirReportablePricePeriods 
	*/
	public List<? extends PriceReportablePeriod> evaluate(TransactionReportInstruction transactionReportInstruction) {
		List<PriceReportablePeriod.PriceReportablePeriodBuilder> emirReportablePricePeriodsBuilder = doEvaluate(transactionReportInstruction);
		
		final List<? extends PriceReportablePeriod> emirReportablePricePeriods;
		if (emirReportablePricePeriodsBuilder == null) {
			emirReportablePricePeriods = null;
		} else {
			emirReportablePricePeriods = emirReportablePricePeriodsBuilder.stream().map(PriceReportablePeriod::build).collect(Collectors.toList());
			objectValidator.validate(PriceReportablePeriod.class, emirReportablePricePeriods);
		}
		
		return emirReportablePricePeriods;
	}

	protected abstract List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<Date> expirationDate(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperC<? extends PriceReportablePeriod> genericReportablePriceSchedule(TransactionReportInstruction transactionReportInstruction);

	public static class UKEMIRReportablePricePeriodDefault extends UKEMIRReportablePricePeriod {
		@Override
		protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction) {
			List<PriceReportablePeriod.PriceReportablePeriodBuilder> emirReportablePricePeriods = new ArrayList<>();
			return assignOutput(emirReportablePricePeriods, transactionReportInstruction);
		}
		
		protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> assignOutput(List<PriceReportablePeriod.PriceReportablePeriodBuilder> emirReportablePricePeriods, TransactionReportInstruction transactionReportInstruction) {
			emirReportablePricePeriods = toBuilder(create_ContinuousPriceSchedule.evaluate(genericReportablePriceSchedule(transactionReportInstruction).getMulti(), expirationDate(transactionReportInstruction).get()));
			
			return Optional.ofNullable(emirReportablePricePeriods)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
		
		@Override
		protected MapperS<Date> expirationDate(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(getExpirationDate.evaluate(transactionReportInstruction));
		}
		
		@Override
		protected MapperC<? extends PriceReportablePeriod> genericReportablePriceSchedule(TransactionReportInstruction transactionReportInstruction) {
			return MapperC.<PriceReportablePeriod>of(getReportablePricePeriod.evaluate(transactionReportInstruction));
		}
	}
}
