package drr.regulation.fca.ukemir.refit.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.fca.ukemir.refit.trade.ExecutionAgent;
import drr.regulation.fca.ukemir.refit.trade.validation.ExecutionAgentTypeFormatValidator;
import drr.regulation.fca.ukemir.refit.trade.validation.ExecutionAgentValidator;
import drr.regulation.fca.ukemir.refit.trade.validation.exists.ExecutionAgentOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.50.0
 */
@RosettaMeta(model=ExecutionAgent.class)
public class ExecutionAgentMeta implements RosettaMetaData<ExecutionAgent> {

	@Override
	public List<Validator<? super ExecutionAgent>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super ExecutionAgent, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super ExecutionAgent> validator(ValidatorFactory factory) {
		return factory.<ExecutionAgent>create(ExecutionAgentValidator.class);
	}

	@Override
	public Validator<? super ExecutionAgent> typeFormatValidator(ValidatorFactory factory) {
		return factory.<ExecutionAgent>create(ExecutionAgentTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super ExecutionAgent> validator() {
		return new ExecutionAgentValidator();
	}

	@Deprecated
	@Override
	public Validator<? super ExecutionAgent> typeFormatValidator() {
		return new ExecutionAgentTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super ExecutionAgent, Set<String>> onlyExistsValidator() {
		return new ExecutionAgentOnlyExistsValidator();
	}
}
