package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomyClassification;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.base.staticdata.asset.common.TaxonomyValue;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.ProductForEvent;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(BaseProductRule.BaseProductRuleDefault.class)
public abstract class BaseProductRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_Commodity_Option qualify_Commodity_Option;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class BaseProductRuleDefault extends BaseProductRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<EconomicTerms> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(economicTermsForProduct.evaluate(item.get())));
			final MapperS<ReferenceWithMetaCommodity> thenArg3 = thenArg2
				.mapSingleToItem(item -> {
					if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(item.get()))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(item.get())))).getOrDefault(false)) {
						return item.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout())
							.first().<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity());
					}
					final Boolean boolean0 = qualify_Commodity_Option.evaluate(item.get());
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of(item.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity());
					}
					final Boolean boolean1 = qualify_Commodity_Swaption.evaluate(item.get());
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of(economicTermsForProduct.evaluate(item.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout())
							.first().<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity());
					}
					if (exists(item.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity())).getOrDefault(false)) {
						return MapperS.of(item.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity());
					}
					return MapperS.of(item.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity());
				});
			final MapperC<ProductTaxonomy> thenArg4 = thenArg3
				.mapSingleToList(item -> item.<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).<ProductTaxonomy>mapC("getProductTaxonomy", commodity -> commodity.getProductTaxonomy()));
			final MapperC<ProductTaxonomy> thenArg5 = thenArg4
				.filterItemNullSafe(item -> areEqual(item.<TaxonomySourceEnum>map("getSource", productTaxonomy -> productTaxonomy.getSource()), MapperS.of(TaxonomySourceEnum.EMIR), CardinalityOperator.All).get());
			final MapperS<ProductTaxonomy> thenArg6 = MapperS.of(thenArg5.get());
			final MapperC<TaxonomyClassification> thenArg7 = thenArg6
				.mapSingleToList(item -> item.<TaxonomyValue>map("getValue", productTaxonomy -> productTaxonomy.getValue()).<TaxonomyClassification>mapC("getClassification", taxonomyValue -> taxonomyValue.getClassification()));
			final MapperC<TaxonomyClassification> thenArg8 = thenArg7
				.filterItemNullSafe(item -> areEqual(item.<Integer>map("getOrdinal", taxonomyClassification -> taxonomyClassification.getOrdinal()), MapperS.of(1), CardinalityOperator.All).get());
			final MapperS<TaxonomyClassification> thenArg9 = MapperS.of(thenArg8.get());
			output = thenArg9
				.mapSingleToItem(item -> item.<String>map("getValue", taxonomyClassification -> taxonomyClassification.getValue())).get();
			
			return output;
		}
	}
}
