package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableDelivery;
import java.time.LocalTime;


@ImplementedBy(DeliveryIntervalEndTimeRule.DeliveryIntervalEndTimeRuleDefault.class)
public abstract class DeliveryIntervalEndTimeRule implements ReportFunction<ReportableDelivery, LocalTime> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public LocalTime evaluate(ReportableDelivery input) {
		LocalTime output = doEvaluate(input);
		
		return output;
	}

	protected abstract LocalTime doEvaluate(ReportableDelivery input);

	public static class DeliveryIntervalEndTimeRuleDefault extends DeliveryIntervalEndTimeRule {
		@Override
		protected LocalTime doEvaluate(ReportableDelivery input) {
			LocalTime output = null;
			return assignOutput(output, input);
		}
		
		protected LocalTime assignOutput(LocalTime output, ReportableDelivery input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> item.<LocalTime>map("getDeliveryEndTime", reportableDelivery -> reportableDelivery.getDeliveryEndTime())).get();
			
			return output;
		}
	}
}
