package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.fca.ukemir.refit.trade.NotionalQuantityScheduleLeg1Report;
import drr.regulation.fca.ukemir.refit.trade.functions.UKEMIRReportableQuantityPeriodLeg1;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(NotionalQuantityScheduleLeg1Rule.NotionalQuantityScheduleLeg1RuleDefault.class)
public abstract class NotionalQuantityScheduleLeg1Rule implements ReportFunction<TransactionReportInstruction, List<? extends NotionalQuantityScheduleLeg1Report>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EffectiveDateOfTheNotionalQuantityOfLeg1Rule effectiveDateOfTheNotionalQuantityOfLeg1Rule;
	@Inject protected EndDateOfTheNotionalQuantityOfLeg1Rule endDateOfTheNotionalQuantityOfLeg1Rule;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected NotionalQuantityInEffectOnAssociatedEffectiveDateOfLeg1Rule notionalQuantityInEffectOnAssociatedEffectiveDateOfLeg1Rule;
	@Inject protected UKEMIRReportableQuantityPeriodLeg1 uKEMIRReportableQuantityPeriodLeg1;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends NotionalQuantityScheduleLeg1Report> evaluate(TransactionReportInstruction input) {
		List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends NotionalQuantityScheduleLeg1Report> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(NotionalQuantityScheduleLeg1Report::build).collect(Collectors.toList());
			objectValidator.validate(NotionalQuantityScheduleLeg1Report.class, output);
		}
		
		return output;
	}

	protected abstract List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class NotionalQuantityScheduleLeg1RuleDefault extends NotionalQuantityScheduleLeg1Rule {
		@Override
		protected List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> assignOutput(List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperC<QuantityReportablePeriod> thenArg1 = thenArg0
				.mapSingleToList(item -> MapperC.<QuantityReportablePeriod>of(uKEMIRReportableQuantityPeriodLeg1.evaluate(item.get())));
			output = toBuilder(thenArg1
				.mapItem(item -> MapperS.of(NotionalQuantityScheduleLeg1Report.builder()
					.setValue(notionalQuantityInEffectOnAssociatedEffectiveDateOfLeg1Rule.evaluate(item.get()))
					.setEffectiveDate(effectiveDateOfTheNotionalQuantityOfLeg1Rule.evaluate(item.get()))
					.setEndDate(endDateOfTheNotionalQuantityOfLeg1Rule.evaluate(item.get()))
					.build())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
