package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToBaseOne18Rate;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.MultiplyPrice;
import drr.standards.iosco.cde.reports.CDEPackageTransactionPriceNotationEnumRule;
import drr.standards.iosco.cde.reports.CDEPackageTransactionPriceRule;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PackageTransactionPriceMonetaryRule.PackageTransactionPriceMonetaryRuleDefault.class)
public abstract class PackageTransactionPriceMonetaryRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPackageTransactionPriceNotationEnumRule cDEPackageTransactionPriceNotationEnumRule;
	@Inject protected CDEPackageTransactionPriceRule cDEPackageTransactionPriceRule;
	@Inject protected FormatToBaseOne18Rate formatToBaseOne18Rate;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected MultiplyPrice multiplyPrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class PackageTransactionPriceMonetaryRuleDefault extends PackageTransactionPriceMonetaryRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<BigDecimal> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					if (areEqual(MapperS.of(cDEPackageTransactionPriceNotationEnumRule.evaluate(item.get())), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(multiplyPrice.evaluate(cDEPackageTransactionPriceRule.evaluate(item.get()), PriceNotationEnum.MONETARY));
					}
					return MapperS.<BigDecimal>ofNull();
				});
			output = MapperS.of(formatToBaseOne18Rate.evaluate(thenArg1.get())).get();
			
			return output;
		}
	}
}
