package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_2101_01")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_2101_01.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_2101_01 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_2101_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if assetClass = \"INTR\" and [\"FRAS\", \"SWAP\", \"SWPT\"] any = contractType then required choice fixedRateOfLeg2, nameOfTheFloatingRateOfLeg2";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_2101_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getActionType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (areEqual(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getAssetClass", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getAssetClass()), MapperS.of("INTR"), CardinalityOperator.All).and(areEqual(MapperC.<String>of(MapperS.of("FRAS"), MapperS.of("SWAP"), MapperS.of("SWPT")), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getContractType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getContractType()), CardinalityOperator.Any)).getOrDefault(false)) {
						return choice(MapperS.of(fCAUKEMIRTransactionReport), Arrays.asList("fixedRateOfLeg2", "nameOfTheFloatingRateOfLeg2"), ChoiceRuleValidationMethod.REQUIRED);
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_2101_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
