package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import drr.regulation.fca.ukemir.refit.trade.PackageTransactionPrice;
import drr.regulation.fca.ukemir.refit.trade.PackageTransactionSpread;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_2111_04")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_2111_04.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_2111_04 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_2111_04";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if packageIdentifier is absent or packageTransactionPrice exists then packageTransactionSpread is absent";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_2111_04 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getActionType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (notExists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getPackageIdentifier", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPackageIdentifier())).or(exists(MapperS.of(fCAUKEMIRTransactionReport).<PackageTransactionPrice>map("getPackageTransactionPrice", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPackageTransactionPrice()))).getOrDefault(false)) {
						return notExists(MapperS.of(fCAUKEMIRTransactionReport).<PackageTransactionSpread>map("getPackageTransactionSpread", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPackageTransactionSpread()));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_2111_04 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
