package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.StrikePriceScheduleReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("StrikePriceScheduleReportMonetaryOrPercentage")
@ImplementedBy(StrikePriceScheduleReportMonetaryOrPercentage.Default.class)
public interface StrikePriceScheduleReportMonetaryOrPercentage extends Validator<StrikePriceScheduleReport> {
	
	String NAME = "StrikePriceScheduleReportMonetaryOrPercentage";
	String DEFINITION = "optional choice strikePriceInEffectOnAssociatedEffectiveDateMonetary, strikePriceInEffectOnAssociatedEffectiveDatePercentage";
	
	class Default implements StrikePriceScheduleReportMonetaryOrPercentage {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, StrikePriceScheduleReport strikePriceScheduleReport) {
			ComparisonResult result = executeDataRule(strikePriceScheduleReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "StrikePriceScheduleReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "StrikePriceScheduleReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(StrikePriceScheduleReport strikePriceScheduleReport) {
			try {
				return choice(MapperS.of(strikePriceScheduleReport), Arrays.asList("strikePriceInEffectOnAssociatedEffectiveDateMonetary", "strikePriceInEffectOnAssociatedEffectiveDatePercentage"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements StrikePriceScheduleReportMonetaryOrPercentage {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, StrikePriceScheduleReport strikePriceScheduleReport) {
			return Collections.emptyList();
		}
	}
}
