package drr.regulation.fca.ukemir.refit.trade.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.fca.ukemir.refit.trade.SpreadOfLeg1;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class SpreadOfLeg1OnlyExistsValidator implements ValidatorWithArg<SpreadOfLeg1, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends SpreadOfLeg1> ValidationResult<SpreadOfLeg1> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("spreadOfLeg1Monetary", ExistenceChecker.isSet((BigDecimal) o.getSpreadOfLeg1Monetary()))
				.put("spreadOfLeg1Percentage", ExistenceChecker.isSet((BigDecimal) o.getSpreadOfLeg1Percentage()))
				.put("spreadOfLeg1Basis", ExistenceChecker.isSet((BigDecimal) o.getSpreadOfLeg1Basis()))
				.put("spreadCurrencyOfLeg1", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSpreadCurrencyOfLeg1()))
				.put("spreadOfLeg1Notation", ExistenceChecker.isSet((PriceNotationEnum) o.getSpreadOfLeg1Notation()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("SpreadOfLeg1", ValidationResult.ValidationType.ONLY_EXISTS, "SpreadOfLeg1", path, "");
		}
		return failure("SpreadOfLeg1", ValidationResult.ValidationType.ONLY_EXISTS, "SpreadOfLeg1", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
