package drr.regulation.jfsa.rewrite.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.jfsa.rewrite.trade.BarrierAndNotation;
import drr.regulation.jfsa.rewrite.trade.validation.BarrierAndNotationTypeFormatValidator;
import drr.regulation.jfsa.rewrite.trade.validation.BarrierAndNotationValidator;
import drr.regulation.jfsa.rewrite.trade.validation.datarule.BarrierAndNotationMonetaryOrDecimalLowerBarrier;
import drr.regulation.jfsa.rewrite.trade.validation.datarule.BarrierAndNotationMonetaryOrDecimalSingleBarrier;
import drr.regulation.jfsa.rewrite.trade.validation.datarule.BarrierAndNotationMonetaryOrDecimalUpperBarrier;
import drr.regulation.jfsa.rewrite.trade.validation.exists.BarrierAndNotationOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.50.0
 */
@RosettaMeta(model=BarrierAndNotation.class)
public class BarrierAndNotationMeta implements RosettaMetaData<BarrierAndNotation> {

	@Override
	public List<Validator<? super BarrierAndNotation>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<BarrierAndNotation>create(BarrierAndNotationMonetaryOrDecimalSingleBarrier.class),
			factory.<BarrierAndNotation>create(BarrierAndNotationMonetaryOrDecimalLowerBarrier.class),
			factory.<BarrierAndNotation>create(BarrierAndNotationMonetaryOrDecimalUpperBarrier.class)
		);
	}
	
	@Override
	public List<Function<? super BarrierAndNotation, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super BarrierAndNotation> validator(ValidatorFactory factory) {
		return factory.<BarrierAndNotation>create(BarrierAndNotationValidator.class);
	}

	@Override
	public Validator<? super BarrierAndNotation> typeFormatValidator(ValidatorFactory factory) {
		return factory.<BarrierAndNotation>create(BarrierAndNotationTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super BarrierAndNotation> validator() {
		return new BarrierAndNotationValidator();
	}

	@Deprecated
	@Override
	public Validator<? super BarrierAndNotation> typeFormatValidator() {
		return new BarrierAndNotationTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super BarrierAndNotation, Set<String>> onlyExistsValidator() {
		return new BarrierAndNotationOnlyExistsValidator();
	}
}
