package drr.regulation.jfsa.rewrite.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.jfsa.rewrite.trade.JFSANonReportable;
import drr.regulation.jfsa.rewrite.trade.validation.JFSANonReportableTypeFormatValidator;
import drr.regulation.jfsa.rewrite.trade.validation.JFSANonReportableValidator;
import drr.regulation.jfsa.rewrite.trade.validation.exists.JFSANonReportableOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.50.0
 */
@RosettaMeta(model=JFSANonReportable.class)
public class JFSANonReportableMeta implements RosettaMetaData<JFSANonReportable> {

	@Override
	public List<Validator<? super JFSANonReportable>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super JFSANonReportable, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super JFSANonReportable> validator(ValidatorFactory factory) {
		return factory.<JFSANonReportable>create(JFSANonReportableValidator.class);
	}

	@Override
	public Validator<? super JFSANonReportable> typeFormatValidator(ValidatorFactory factory) {
		return factory.<JFSANonReportable>create(JFSANonReportableTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super JFSANonReportable> validator() {
		return new JFSANonReportableValidator();
	}

	@Deprecated
	@Override
	public Validator<? super JFSANonReportable> typeFormatValidator() {
		return new JFSANonReportableTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super JFSANonReportable, Set<String>> onlyExistsValidator() {
		return new JFSANonReportableOnlyExistsValidator();
	}
}
