package drr.regulation.jfsa.rewrite.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.jfsa.rewrite.trade.NotionalAmountScheduleLeg1Report;
import drr.regulation.jfsa.rewrite.trade.validation.NotionalAmountScheduleLeg1ReportTypeFormatValidator;
import drr.regulation.jfsa.rewrite.trade.validation.NotionalAmountScheduleLeg1ReportValidator;
import drr.regulation.jfsa.rewrite.trade.validation.exists.NotionalAmountScheduleLeg1ReportOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.50.0
 */
@RosettaMeta(model=NotionalAmountScheduleLeg1Report.class)
public class NotionalAmountScheduleLeg1ReportMeta implements RosettaMetaData<NotionalAmountScheduleLeg1Report> {

	@Override
	public List<Validator<? super NotionalAmountScheduleLeg1Report>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super NotionalAmountScheduleLeg1Report, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super NotionalAmountScheduleLeg1Report> validator(ValidatorFactory factory) {
		return factory.<NotionalAmountScheduleLeg1Report>create(NotionalAmountScheduleLeg1ReportValidator.class);
	}

	@Override
	public Validator<? super NotionalAmountScheduleLeg1Report> typeFormatValidator(ValidatorFactory factory) {
		return factory.<NotionalAmountScheduleLeg1Report>create(NotionalAmountScheduleLeg1ReportTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super NotionalAmountScheduleLeg1Report> validator() {
		return new NotionalAmountScheduleLeg1ReportValidator();
	}

	@Deprecated
	@Override
	public Validator<? super NotionalAmountScheduleLeg1Report> typeFormatValidator() {
		return new NotionalAmountScheduleLeg1ReportTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super NotionalAmountScheduleLeg1Report, Set<String>> onlyExistsValidator() {
		return new NotionalAmountScheduleLeg1ReportOnlyExistsValidator();
	}
}
