package drr.regulation.jfsa.rewrite.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.jfsa.rewrite.trade.PackageTransactionPrice;
import drr.regulation.jfsa.rewrite.trade.validation.PackageTransactionPriceTypeFormatValidator;
import drr.regulation.jfsa.rewrite.trade.validation.PackageTransactionPriceValidator;
import drr.regulation.jfsa.rewrite.trade.validation.datarule.PackageTransactionPriceMonetaryOrDecimalOrBasis;
import drr.regulation.jfsa.rewrite.trade.validation.exists.PackageTransactionPriceOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.50.0
 */
@RosettaMeta(model=PackageTransactionPrice.class)
public class PackageTransactionPriceMeta implements RosettaMetaData<PackageTransactionPrice> {

	@Override
	public List<Validator<? super PackageTransactionPrice>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<PackageTransactionPrice>create(PackageTransactionPriceMonetaryOrDecimalOrBasis.class)
		);
	}
	
	@Override
	public List<Function<? super PackageTransactionPrice, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super PackageTransactionPrice> validator(ValidatorFactory factory) {
		return factory.<PackageTransactionPrice>create(PackageTransactionPriceValidator.class);
	}

	@Override
	public Validator<? super PackageTransactionPrice> typeFormatValidator(ValidatorFactory factory) {
		return factory.<PackageTransactionPrice>create(PackageTransactionPriceTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super PackageTransactionPrice> validator() {
		return new PackageTransactionPriceValidator();
	}

	@Deprecated
	@Override
	public Validator<? super PackageTransactionPrice> typeFormatValidator() {
		return new PackageTransactionPriceTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super PackageTransactionPrice, Set<String>> onlyExistsValidator() {
		return new PackageTransactionPriceOnlyExistsValidator();
	}
}
