package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.event.common.BusinessEvent;
import cdm.event.common.EventIntentEnum;
import cdm.event.common.Instruction;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.TransferInstruction;
import cdm.event.qualification.functions.Qualify_Allocation;
import cdm.event.qualification.functions.Qualify_ClearedTrade;
import cdm.event.qualification.functions.Qualify_Compression;
import cdm.event.qualification.functions.Qualify_ContractFormation;
import cdm.event.qualification.functions.Qualify_CorporateActionDetermined;
import cdm.event.qualification.functions.Qualify_CreditEventDetermined;
import cdm.event.qualification.functions.Qualify_Exercise;
import cdm.event.qualification.functions.Qualify_FullReturn;
import cdm.event.qualification.functions.Qualify_Increase;
import cdm.event.qualification.functions.Qualify_IndexTransition;
import cdm.event.qualification.functions.Qualify_Novation;
import cdm.event.qualification.functions.Qualify_PartialNovation;
import cdm.event.qualification.functions.Qualify_PartialTermination;
import cdm.event.qualification.functions.Qualify_Reallocation;
import cdm.event.qualification.functions.Qualify_Renegotiation;
import cdm.event.qualification.functions.Qualify_Termination;
import cdm.event.workflow.WorkflowState;
import cdm.event.workflow.WorkflowStatusEnum;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.EventTypeEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsActionTypeCORR;
import drr.regulation.common.functions.IsActionTypeEROR;
import drr.regulation.common.functions.IsActionTypePRTO;
import drr.regulation.common.functions.IsActionTypeREVI;
import drr.regulation.common.functions.IsActionTypeVALU;
import drr.regulation.common.functions.IsEventTypePTNG;
import drr.regulation.common.functions.IsEventTypeUPDT;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(EventTypeRule.EventTypeRuleDefault.class)
public abstract class EventTypeRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsActionTypeCORR isActionTypeCORR;
	@Inject protected IsActionTypeEROR isActionTypeEROR;
	@Inject protected IsActionTypePRTO isActionTypePRTO;
	@Inject protected IsActionTypeREVI isActionTypeREVI;
	@Inject protected IsActionTypeVALU isActionTypeVALU;
	@Inject protected IsEventTypePTNG isEventTypePTNG;
	@Inject protected IsEventTypeUPDT isEventTypeUPDT;
	@Inject protected Qualify_Allocation qualify_Allocation;
	@Inject protected Qualify_ClearedTrade qualify_ClearedTrade;
	@Inject protected Qualify_Compression qualify_Compression;
	@Inject protected Qualify_ContractFormation qualify_ContractFormation;
	@Inject protected Qualify_CorporateActionDetermined qualify_CorporateActionDetermined;
	@Inject protected Qualify_CreditEventDetermined qualify_CreditEventDetermined;
	@Inject protected Qualify_Exercise qualify_Exercise;
	@Inject protected Qualify_FullReturn qualify_FullReturn;
	@Inject protected Qualify_Increase qualify_Increase;
	@Inject protected Qualify_IndexTransition qualify_IndexTransition;
	@Inject protected Qualify_Novation qualify_Novation;
	@Inject protected Qualify_PartialNovation qualify_PartialNovation;
	@Inject protected Qualify_PartialTermination qualify_PartialTermination;
	@Inject protected Qualify_Reallocation qualify_Reallocation;
	@Inject protected Qualify_Renegotiation qualify_Renegotiation;
	@Inject protected Qualify_Termination qualify_Termination;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class EventTypeRuleDefault extends EventTypeRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(reportableEvent -> {
					final MapperS<WorkflowStep> thenArg;
					if (areEqual(MapperS.of(isActionTypeCORR.evaluate(input)), MapperS.of(false), CardinalityOperator.All).and(areEqual(MapperS.of(isActionTypeEROR.evaluate(input)), MapperS.of(false), CardinalityOperator.All)).and(areEqual(MapperS.of(isActionTypeREVI.evaluate(input)), MapperS.of(false), CardinalityOperator.All)).and(areEqual(MapperS.of(isActionTypePRTO.evaluate(input)), MapperS.of(false), CardinalityOperator.All)).and(areEqual(MapperS.of(isActionTypeVALU.evaluate(input)), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
						thenArg = MapperS.of(input)
							.mapSingleToItem(item -> reportableEvent.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()));
					} else {
						thenArg = MapperS.<WorkflowStep>ofNull();
					}
					final MapperS<String> ifThenElseResult;
					if (ComparisonResult.of(MapperS.of(isEventTypePTNG.evaluate(reportableEvent.get()))).or(ComparisonResult.of(MapperS.of(isActionTypePRTO.evaluate(reportableEvent.get())))).getOrDefault(false)) {
						ifThenElseResult = MapperS.of(EventTypeEnum.PTNG).map("to-string", EventTypeEnum::toDisplayString);
					} else {
						final Boolean _boolean = isEventTypeUPDT.evaluate(reportableEvent.get());
						if ((_boolean == null ? false : _boolean)) {
							ifThenElseResult = MapperS.of(EventTypeEnum.UPDT).map("to-string", EventTypeEnum::toDisplayString);
						} else if (areEqual(MapperS.of(qualify_Novation.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), MapperS.of(true), CardinalityOperator.All).or(areEqual(MapperS.of(qualify_PartialNovation.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), MapperS.of(true), CardinalityOperator.All)).or(areEqual(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<EventIntentEnum>map("getIntent", businessEvent -> businessEvent.getIntent()), MapperS.of(EventIntentEnum.NOVATION), CardinalityOperator.All)).getOrDefault(false)) {
							ifThenElseResult = MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString);
						} else if (areEqual(MapperS.of(qualify_Allocation.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), MapperS.of(true), CardinalityOperator.All).or(areEqual(MapperS.of(qualify_Reallocation.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), MapperS.of(true), CardinalityOperator.All)).or(areEqual(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<EventIntentEnum>map("getIntent", businessEvent -> businessEvent.getIntent()), MapperS.of(EventIntentEnum.ALLOCATION), CardinalityOperator.All)).getOrDefault(false)) {
							ifThenElseResult = MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString);
						} else if (areEqual(MapperS.of(qualify_Exercise.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), MapperS.of(true), CardinalityOperator.All).or(areEqual(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<EventIntentEnum>map("getIntent", businessEvent -> businessEvent.getIntent()), MapperS.of(EventIntentEnum.OPTION_EXERCISE), CardinalityOperator.All)).getOrDefault(false)) {
							ifThenElseResult = MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString);
						} else if (areEqual(MapperS.of(qualify_ClearedTrade.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), MapperS.of(true), CardinalityOperator.All).or(areEqual(thenArg.<WorkflowState>map("getWorkflowState", workflowStep -> workflowStep.getWorkflowState()).<WorkflowStatusEnum>map("getWorkflowStatus", workflowState -> workflowState.getWorkflowStatus()), MapperS.of(WorkflowStatusEnum.CLEARED), CardinalityOperator.All)).or(areEqual(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<EventIntentEnum>map("getIntent", businessEvent -> businessEvent.getIntent()), MapperS.of(EventIntentEnum.CLEARING), CardinalityOperator.All)).getOrDefault(false)) {
							ifThenElseResult = MapperS.of(EventTypeEnum.CLRG).map("to-string", EventTypeEnum::toDisplayString);
						} else if (areEqual(MapperS.of(qualify_Compression.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), MapperS.of(true), CardinalityOperator.All).or(areEqual(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<EventIntentEnum>map("getIntent", businessEvent -> businessEvent.getIntent()), MapperS.of(EventIntentEnum.COMPRESSION), CardinalityOperator.All)).getOrDefault(false)) {
							ifThenElseResult = MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString);
						} else if (ComparisonResult.of(MapperS.of(qualify_Termination.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get()))).or(areEqual(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<EventIntentEnum>map("getIntent", businessEvent -> businessEvent.getIntent()), MapperS.of(EventIntentEnum.EARLY_TERMINATION_PROVISION), CardinalityOperator.All)).or(ComparisonResult.of(MapperS.of(qualify_PartialTermination.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())))).or(areEqual(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<EventIntentEnum>map("getIntent", businessEvent -> businessEvent.getIntent()), MapperS.of(EventIntentEnum.DECREASE), CardinalityOperator.All)).getOrDefault(false)) {
							ifThenElseResult = MapperS.of(EventTypeEnum.ETRM).map("to-string", EventTypeEnum::toDisplayString);
						} else if (ComparisonResult.of(MapperS.of(qualify_CreditEventDetermined.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get()))).or(areEqual(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<EventIntentEnum>map("getIntent", businessEvent -> businessEvent.getIntent()), MapperS.of(EventIntentEnum.CREDIT_EVENT), CardinalityOperator.All)).getOrDefault(false)) {
							ifThenElseResult = MapperS.of(EventTypeEnum.CREV).map("to-string", EventTypeEnum::toDisplayString);
						} else if (ComparisonResult.of(MapperS.of(qualify_CorporateActionDetermined.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get()))).or(areEqual(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<EventIntentEnum>map("getIntent", businessEvent -> businessEvent.getIntent()), MapperS.of(EventIntentEnum.CORPORATE_ACTION_ADJUSTMENT), CardinalityOperator.All)).getOrDefault(false)) {
							ifThenElseResult = MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString);
						} else if (areEqual(MapperS.of(qualify_ContractFormation.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), MapperS.of(true), CardinalityOperator.All).or(areEqual(MapperS.of(qualify_Increase.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), MapperS.of(true), CardinalityOperator.All)).or(areEqual(MapperS.of(qualify_Renegotiation.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), MapperS.of(true), CardinalityOperator.All)).or(areEqual(MapperS.of(qualify_IndexTransition.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), MapperS.of(true), CardinalityOperator.All)).or(areEqual(MapperS.of(qualify_FullReturn.evaluate(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), MapperS.of(true), CardinalityOperator.All)).or(exists(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<Instruction>mapC("getInstruction", businessEvent -> businessEvent.getInstruction()).<PrimitiveInstruction>map("getPrimitiveInstruction", instruction -> instruction.getPrimitiveInstruction()).<QuantityChangeInstruction>map("getQuantityChange", primitiveInstruction -> primitiveInstruction.getQuantityChange()))).or(exists(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<Instruction>mapC("getInstruction", businessEvent -> businessEvent.getInstruction()).<PrimitiveInstruction>map("getPrimitiveInstruction", instruction -> instruction.getPrimitiveInstruction()).<TransferInstruction>map("getTransfer", primitiveInstruction -> primitiveInstruction.getTransfer()))).or(areEqual(thenArg.<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<EventIntentEnum>map("getIntent", businessEvent -> businessEvent.getIntent()), MapperS.of(EventIntentEnum.CONTRACT_TERMS_AMENDMENT), CardinalityOperator.All)).getOrDefault(false)) {
							ifThenElseResult = MapperS.of(EventTypeEnum.TRAD).map("to-string", EventTypeEnum::toDisplayString);
						} else {
							ifThenElseResult = MapperS.<String>ofNull();
						}
					}
					return ifThenElseResult;
				}).get();
			
			return output;
		}
	}
}
