package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.jfsa.rewrite.trade.BarrierAndNotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("BarrierAndNotationMonetaryOrDecimalUpperBarrier")
@ImplementedBy(BarrierAndNotationMonetaryOrDecimalUpperBarrier.Default.class)
public interface BarrierAndNotationMonetaryOrDecimalUpperBarrier extends Validator<BarrierAndNotation> {
	
	String NAME = "BarrierAndNotationMonetaryOrDecimalUpperBarrier";
	String DEFINITION = "optional choice upperBarrierPriceMonetary, upperBarrierPriceDecimal";
	
	class Default implements BarrierAndNotationMonetaryOrDecimalUpperBarrier {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, BarrierAndNotation barrierAndNotation) {
			ComparisonResult result = executeDataRule(barrierAndNotation);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "BarrierAndNotation", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "BarrierAndNotation", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(BarrierAndNotation barrierAndNotation) {
			try {
				return choice(MapperS.of(barrierAndNotation), Arrays.asList("upperBarrierPriceMonetary", "upperBarrierPriceDecimal"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements BarrierAndNotationMonetaryOrDecimalUpperBarrier {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, BarrierAndNotation barrierAndNotation) {
			return Collections.emptyList();
		}
	}
}
