package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.common.EnrichmentData;
import drr.enrichment.lei.LeiData;
import drr.enrichment.lei.functions.GetOrFetchLeiData;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.util.functions.SubString;
import drr.regulation.jfsa.rewrite.trade.JFSANonReportable;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("JFSATransactionReportDTCC_JFSA_BR_0110_04")
@ImplementedBy(JFSATransactionReportDTCC_JFSA_BR_0110_04.Default.class)
public interface JFSATransactionReportDTCC_JFSA_BR_0110_04 extends Validator<JFSATransactionReport> {
	
	String NAME = "JFSATransactionReportDTCC_JFSA_BR_0110_04";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and assetClass = \"CURR\" then (if customBasketCode exists and GetOrFetchLeiData(nonReportable -> enrichment -> leiData, SubString(customBasketCode, 1, 20)) -> lei exists then underlyingIdentificationType exists)";
	
	class Default implements JFSATransactionReportDTCC_JFSA_BR_0110_04 {
	
		@Inject protected GetOrFetchLeiData getOrFetchLeiData;
		
		@Inject protected SubString subString;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			ComparisonResult result = executeDataRule(jFSATransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(JFSATransactionReport jFSATransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(jFSATransactionReport).<String>map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), CardinalityOperator.Any).and(areEqual(MapperS.of(jFSATransactionReport).<String>map("getAssetClass", _jFSATransactionReport -> _jFSATransactionReport.getAssetClass()), MapperS.of("CURR"), CardinalityOperator.All)).getOrDefault(false)) {
					if (exists(MapperS.of(jFSATransactionReport).<String>map("getCustomBasketCode", _jFSATransactionReport -> _jFSATransactionReport.getCustomBasketCode())).and(exists(MapperS.of(getOrFetchLeiData.evaluate(MapperS.of(jFSATransactionReport).<JFSANonReportable>map("getNonReportable", _jFSATransactionReport -> _jFSATransactionReport.getNonReportable()).<EnrichmentData>map("getEnrichment", jFSANonReportable -> jFSANonReportable.getEnrichment()).<LeiData>mapC("getLeiData", enrichmentData -> enrichmentData.getLeiData()).getMulti(), subString.evaluate(MapperS.of(jFSATransactionReport).<String>map("getCustomBasketCode", _jFSATransactionReport -> _jFSATransactionReport.getCustomBasketCode()).get(), 1, 20))).<String>map("getLei", leiData -> leiData.getLei()))).getOrDefault(false)) {
						return exists(MapperS.of(jFSATransactionReport).<String>map("getUnderlyingIdentificationType", _jFSATransactionReport -> _jFSATransactionReport.getUnderlyingIdentificationType()));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements JFSATransactionReportDTCC_JFSA_BR_0110_04 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
