package drr.regulation.jfsa.rewrite.trade.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.jfsa.rewrite.trade.NotionalAmountScheduleLeg1Report;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class NotionalAmountScheduleLeg1ReportOnlyExistsValidator implements ValidatorWithArg<NotionalAmountScheduleLeg1Report, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends NotionalAmountScheduleLeg1Report> ValidationResult<NotionalAmountScheduleLeg1Report> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("amount", ExistenceChecker.isSet((BigDecimal) o.getAmount()))
				.put("effectiveDate", ExistenceChecker.isSet((Date) o.getEffectiveDate()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("NotionalAmountScheduleLeg1Report", ValidationResult.ValidationType.ONLY_EXISTS, "NotionalAmountScheduleLeg1Report", path, "");
		}
		return failure("NotionalAmountScheduleLeg1Report", ValidationResult.ValidationType.ONLY_EXISTS, "NotionalAmountScheduleLeg1Report", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
