package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.standards.iosco.cde.reports.CDEStrikePriceScheduleEffectiveDateRule;
import javax.inject.Inject;


@ImplementedBy(EffectiveDateOfStrikePriceRule.EffectiveDateOfStrikePriceRuleDefault.class)
public abstract class EffectiveDateOfStrikePriceRule implements ReportFunction<PriceReportablePeriod, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEStrikePriceScheduleEffectiveDateRule cDEStrikePriceScheduleEffectiveDateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(PriceReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(PriceReportablePeriod input);

	public static class EffectiveDateOfStrikePriceRuleDefault extends EffectiveDateOfStrikePriceRule {
		@Override
		protected Date doEvaluate(PriceReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, PriceReportablePeriod input) {
			output = cDEStrikePriceScheduleEffectiveDateRule.evaluate(input);
			
			return output;
		}
	}
}
