package drr.regulation.mas.rewrite.trade.reports;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetReportableQuantityPeriodLeg2;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.mas.rewrite.trade.NotionalQuantityScheduleLeg2Report;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(NotionalQuantityScheduleLeg2Rule.NotionalQuantityScheduleLeg2RuleDefault.class)
public abstract class NotionalQuantityScheduleLeg2Rule implements ReportFunction<TransactionReportInstruction, List<? extends NotionalQuantityScheduleLeg2Report>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected GetReportableQuantityPeriodLeg2 getReportableQuantityPeriodLeg2;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected NotionalQuantityScheduleLeg2EffectiveDateRule notionalQuantityScheduleLeg2EffectiveDateRule;
	@Inject protected NotionalQuantityScheduleLeg2EndDateRule notionalQuantityScheduleLeg2EndDateRule;
	@Inject protected NotionalQuantityScheduleLeg2ValueRule notionalQuantityScheduleLeg2ValueRule;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends NotionalQuantityScheduleLeg2Report> evaluate(TransactionReportInstruction input) {
		List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends NotionalQuantityScheduleLeg2Report> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(NotionalQuantityScheduleLeg2Report::build).collect(Collectors.toList());
			objectValidator.validate(NotionalQuantityScheduleLeg2Report.class, output);
		}
		
		return output;
	}

	protected abstract List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class NotionalQuantityScheduleLeg2RuleDefault extends NotionalQuantityScheduleLeg2Rule {
		@Override
		protected List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> assignOutput(List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<Trade> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperC<QuantityReportablePeriod> thenArg2 = thenArg1
				.mapSingleToList(item -> MapperC.<QuantityReportablePeriod>of(getReportableQuantityPeriodLeg2.evaluate(item.get())));
			final MapperC<NotionalQuantityScheduleLeg2Report> thenArg3 = thenArg2
				.mapItem(item -> MapperS.of(NotionalQuantityScheduleLeg2Report.builder()
					.setValue(notionalQuantityScheduleLeg2ValueRule.evaluate(item.get()))
					.setEffectiveDate(notionalQuantityScheduleLeg2EffectiveDateRule.evaluate(item.get()))
					.setEndDate(notionalQuantityScheduleLeg2EndDateRule.evaluate(item.get()))
					.build()));
			output = toBuilder(thenArg3
				.sort(item -> item.<Date>map("getEffectiveDate", notionalQuantityScheduleLeg2Report -> notionalQuantityScheduleLeg2Report.getEffectiveDate())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
