package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.standards.iosco.cde.reports.CDEStrikePriceScheduleAmountFormatMonetaryRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(StrikePriceInEffectOnAssociatedEffectiveDateMonetaryRule.StrikePriceInEffectOnAssociatedEffectiveDateMonetaryRuleDefault.class)
public abstract class StrikePriceInEffectOnAssociatedEffectiveDateMonetaryRule implements ReportFunction<PriceReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEStrikePriceScheduleAmountFormatMonetaryRule cDEStrikePriceScheduleAmountFormatMonetaryRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(PriceReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(PriceReportablePeriod input);

	public static class StrikePriceInEffectOnAssociatedEffectiveDateMonetaryRuleDefault extends StrikePriceInEffectOnAssociatedEffectiveDateMonetaryRule {
		@Override
		protected BigDecimal doEvaluate(PriceReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, PriceReportablePeriod input) {
			output = cDEStrikePriceScheduleAmountFormatMonetaryRule.evaluate(input);
			
			return output;
		}
	}
}
