package drr.regulation.mas.rewrite.trade.reports;

import cdm.base.staticdata.identifier.IdentifiedList;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Spot_Forward;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetPackageInformation;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.standards.iosco.cde.reports.CDEPackageIdentifierRule;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(SwapLinkIDRule.SwapLinkIDRuleDefault.class)
public abstract class SwapLinkIDRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPackageIdentifierRule cDEPackageIdentifierRule;
	@Inject protected GetPackageInformation getPackageInformation;
	@Inject protected IsAllowableActionForMAS isAllowableActionForMAS;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_ForeignExchange_Spot_Forward qualify_ForeignExchange_Spot_Forward;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class SwapLinkIDRuleDefault extends SwapLinkIDRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> ComparisonResult.of(MapperS.of(isAllowableActionForMAS.evaluate(item.get()))).and(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_Spot_Forward.evaluate(MapperS.of(productForEvent.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).get());
			final MapperS<IdentifiedList> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(getPackageInformation.evaluate(item.get())));
			final MapperC<FieldWithMetaString> thenArg2 = thenArg1
				.mapSingleToList(item -> MapperC.<FieldWithMetaString>of(cDEPackageIdentifierRule.evaluate(item.get()).stream()
					.<FieldWithMetaString>map(string -> FieldWithMetaString.builder().setValue(string).build())
					.collect(Collectors.toList())
				));
			final FieldWithMetaString fieldWithMetaString = MapperS.of(thenArg2.get()).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
