package drr.regulation.mas.rewrite.trade.reports;

import cdm.event.common.Trade;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg1;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.IsCommodityFixedPriceForward;
import drr.regulation.common.functions.IsCommodityFloatingPriceForward;
import drr.regulation.common.functions.IsCommoditySwapFixedFloat;
import drr.regulation.common.functions.IsCommoditySwapFloatFloat;
import drr.regulation.common.functions.IsEquity;
import drr.regulation.common.functions.IsEquityForward;
import drr.regulation.common.functions.IsSingleCommodityPayoutProduct;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.standards.iosco.cde.reports.CDECommodityTotalNotionalQuantityRule;
import drr.standards.iosco.cde.reports.CDEEquityTotalNotionalQuantityRule;
import drr.standards.iosco.cde.reports.CDEFixedPriceTotalNotionalQuantityRule;
import drr.standards.iosco.cde.reports.CDEOptionTotalNotionalQuantityRule;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.inject.Inject;


@ImplementedBy(TotalNotionalQuantityOfTheContractOrLeg1Rule.TotalNotionalQuantityOfTheContractOrLeg1RuleDefault.class)
public abstract class TotalNotionalQuantityOfTheContractOrLeg1Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDECommodityTotalNotionalQuantityRule cDECommodityTotalNotionalQuantityRule;
	@Inject protected CDEEquityTotalNotionalQuantityRule cDEEquityTotalNotionalQuantityRule;
	@Inject protected CDEFixedPriceTotalNotionalQuantityRule cDEFixedPriceTotalNotionalQuantityRule;
	@Inject protected CDEOptionTotalNotionalQuantityRule cDEOptionTotalNotionalQuantityRule;
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected IsAllowableActionForMAS isAllowableActionForMAS;
	@Inject protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsCommoditySwapFixedFloat isCommoditySwapFixedFloat;
	@Inject protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;
	@Inject protected IsEquity isEquity;
	@Inject protected IsEquityForward isEquityForward;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
	@Inject protected Qualify_Commodity_Option qualify_Commodity_Option;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected TradeForEvent tradeForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class TotalNotionalQuantityOfTheContractOrLeg1RuleDefault extends TotalNotionalQuantityOfTheContractOrLeg1Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForMAS.evaluate(item.get()));
			final MapperS<Trade> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperS<Trade> thenArg2 = thenArg1
				.filterSingleNullSafe(item -> ComparisonResult.of(MapperS.of(qualify_AssetClass_Equity.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).or(ComparisonResult.of(MapperS.of(qualify_AssetClass_Commodity.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).get());
			output = thenArg2
				.mapSingleToItem(item -> {
					final MapperS<BigDecimal> ifThenElseResult;
					if (ComparisonResult.of(MapperS.of(isEquity.evaluate(productForTrade.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isEquityForward.evaluate(productForTrade.evaluate(item.get()))))).getOrDefault(false)) {
						ifThenElseResult = MapperS.of(cDEEquityTotalNotionalQuantityRule.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).get()));
					} else {
						final Boolean boolean0 = isCommoditySwapFloatFloat.evaluate(productForTrade.evaluate(item.get()));
						if ((boolean0 == null ? false : boolean0)) {
							ifThenElseResult = MapperS.of(cDECommodityTotalNotionalQuantityRule.evaluate(commodityLeg1.evaluate(productForTrade.evaluate(item.get()))));
						} else if (ComparisonResult.of(MapperS.of(isSingleCommodityPayoutProduct.evaluate(productForTrade.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isCommodityFloatingPriceForward.evaluate(productForTrade.evaluate(item.get()))))).getOrDefault(false)) {
							ifThenElseResult = MapperS.of(cDECommodityTotalNotionalQuantityRule.evaluate(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()));
						} else {
							final Boolean boolean1 = isCommoditySwapFixedFloat.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean1 == null ? false : boolean1)) {
								ifThenElseResult = MapperS.of(cDEFixedPriceTotalNotionalQuantityRule.evaluate(fixedPriceLeg1.evaluate(productForTrade.evaluate(item.get()))));
							} else {
								final Boolean boolean2 = isCommodityFixedPriceForward.evaluate(productForTrade.evaluate(item.get()));
								if ((boolean2 == null ? false : boolean2)) {
									ifThenElseResult = MapperS.of(cDEFixedPriceTotalNotionalQuantityRule.evaluate(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get()));
								} else if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())))).and(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTermsForProduct.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get()))))))).getOrDefault(false)) {
									ifThenElseResult = MapperS.of(cDECommodityTotalNotionalQuantityRule.evaluate(commodityLeg1.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get())))));
								} else if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())))).and(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTermsForProduct.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get()))))))).getOrDefault(false)) {
									ifThenElseResult = MapperS.of(cDEFixedPriceTotalNotionalQuantityRule.evaluate(fixedPriceLeg1.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get())))));
								} else {
									final Boolean boolean3 = qualify_Commodity_Option.evaluate(economicTermsForProduct.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()));
									if ((boolean3 == null ? false : boolean3)) {
										ifThenElseResult = MapperS.of(cDEOptionTotalNotionalQuantityRule.evaluate(MapperS.of(economicTermsForProduct.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()));
									} else {
										ifThenElseResult = MapperS.<BigDecimal>ofNull();
									}
								}
							}
						}
					}
					final BigInteger bigInteger = new BigInteger("9999999999999999999999999");
					return MapperS.of(ifThenElseResult.getOrDefault((bigInteger == null ? null : new BigDecimal(bigInteger))));
				}).get();
			
			return output;
		}
	}
}
