package drr.regulation.mas.rewrite.trade.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg2;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class SpreadOfLeg2Validator implements Validator<SpreadOfLeg2> {

	private List<ComparisonResult> getComparisonResults(SpreadOfLeg2 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("spreadOfLeg2Monetary", (BigDecimal) o.getSpreadOfLeg2Monetary() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadOfLeg2Decimal", (BigDecimal) o.getSpreadOfLeg2Decimal() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadOfLeg2Basis", (BigDecimal) o.getSpreadOfLeg2Basis() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadNotationOfLeg2", (PriceNotationEnum) o.getSpreadNotationOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadCurrencyOfLeg2", (ISOCurrencyCodeEnum) o.getSpreadCurrencyOfLeg2() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadOfLeg2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("SpreadOfLeg2", ValidationResult.ValidationType.CARDINALITY, "SpreadOfLeg2", path, "", res.getError());
				}
				return success("SpreadOfLeg2", ValidationResult.ValidationType.CARDINALITY, "SpreadOfLeg2", path, "");
			})
			.collect(toList());
	}

}
