package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.StrikePriceScheduleReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0106_01")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0106_01.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0106_01 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0106_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType then ((strikePriceSchedule -> effectiveDate count = strikePriceSchedule -> strikePriceInEffectOnAssociatedEffectiveDateMonetary count or strikePriceSchedule -> effectiveDate count = strikePriceSchedule -> strikePriceInEffectOnAssociatedEffectiveDateDecimal count) and (strikePriceSchedule -> endDate count = strikePriceSchedule -> strikePriceInEffectOnAssociatedEffectiveDateMonetary count or strikePriceSchedule -> endDate count = strikePriceSchedule -> strikePriceInEffectOnAssociatedEffectiveDateDecimal count))";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0106_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					return areEqual(MapperS.of(MapperS.of(mASTransactionReport).<StrikePriceScheduleReport>mapC("getStrikePriceSchedule", _mASTransactionReport -> _mASTransactionReport.getStrikePriceSchedule()).<Date>map("getEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getEffectiveDate()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<StrikePriceScheduleReport>mapC("getStrikePriceSchedule", _mASTransactionReport -> _mASTransactionReport.getStrikePriceSchedule()).<BigDecimal>map("getStrikePriceInEffectOnAssociatedEffectiveDateMonetary", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()).resultCount()), CardinalityOperator.All).or(areEqual(MapperS.of(MapperS.of(mASTransactionReport).<StrikePriceScheduleReport>mapC("getStrikePriceSchedule", _mASTransactionReport -> _mASTransactionReport.getStrikePriceSchedule()).<Date>map("getEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getEffectiveDate()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<StrikePriceScheduleReport>mapC("getStrikePriceSchedule", _mASTransactionReport -> _mASTransactionReport.getStrikePriceSchedule()).<BigDecimal>map("getStrikePriceInEffectOnAssociatedEffectiveDateDecimal", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateDecimal()).resultCount()), CardinalityOperator.All)).and(areEqual(MapperS.of(MapperS.of(mASTransactionReport).<StrikePriceScheduleReport>mapC("getStrikePriceSchedule", _mASTransactionReport -> _mASTransactionReport.getStrikePriceSchedule()).<Date>map("getEndDate", strikePriceScheduleReport -> strikePriceScheduleReport.getEndDate()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<StrikePriceScheduleReport>mapC("getStrikePriceSchedule", _mASTransactionReport -> _mASTransactionReport.getStrikePriceSchedule()).<BigDecimal>map("getStrikePriceInEffectOnAssociatedEffectiveDateMonetary", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()).resultCount()), CardinalityOperator.All).or(areEqual(MapperS.of(MapperS.of(mASTransactionReport).<StrikePriceScheduleReport>mapC("getStrikePriceSchedule", _mASTransactionReport -> _mASTransactionReport.getStrikePriceSchedule()).<Date>map("getEndDate", strikePriceScheduleReport -> strikePriceScheduleReport.getEndDate()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<StrikePriceScheduleReport>mapC("getStrikePriceSchedule", _mASTransactionReport -> _mASTransactionReport.getStrikePriceSchedule()).<BigDecimal>map("getStrikePriceInEffectOnAssociatedEffectiveDateDecimal", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateDecimal()).resultCount()), CardinalityOperator.All)));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0106_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
