package drr.regulation.mas.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.OtherPaymentReport;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg1;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg2;
import iso20022.auth030.mas.PaymentType4Code;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0127_03")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0127_03.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0127_03 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0127_03";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and assetClass = \"CRDT\" and (otherPayment -> amount exists or otherPayment -> currency exists or otherPayment -> payer exists or otherPayment -> receiver exists) then otherPayment -> paymentType exists and (if actionType = ActionTypeEnum -> NEWT to-string and fixedRateOfLeg1 is absent and fixedRateOfLeg2 is absent and spreadOfLeg1 is absent and spreadOfLeg2 is absent then otherPayment -> paymentType all = PaymentType4Code -> UFRO) and (if otherPayment -> paymentType count <> otherPayment -> amount count or otherPayment -> paymentType count <> otherPayment -> currency count or otherPayment -> paymentType count <> otherPayment -> date count or otherPayment -> paymentType count <> otherPayment -> payer count or otherPayment -> paymentType count <> otherPayment -> receiver count then False)";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0127_03 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).and(areEqual(MapperS.of(mASTransactionReport).<String>map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), MapperS.of("CRDT"), CardinalityOperator.All)).and(exists(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<BigDecimal>map("getAmount", otherPaymentReport -> otherPaymentReport.getAmount())).or(exists(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<ISOCurrencyCodeEnum>map("getCurrency", otherPaymentReport -> otherPaymentReport.getCurrency()))).or(exists(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getPayer", otherPaymentReport -> otherPaymentReport.getPayer()))).or(exists(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver())))).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (areEqual(MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).and(notExists(MapperS.of(mASTransactionReport).<BigDecimal>map("getFixedRateOfLeg1", _mASTransactionReport -> _mASTransactionReport.getFixedRateOfLeg1()))).and(notExists(MapperS.of(mASTransactionReport).<BigDecimal>map("getFixedRateOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRateOfLeg2()))).and(notExists(MapperS.of(mASTransactionReport).<SpreadOfLeg1>map("getSpreadOfLeg1", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg1()))).and(notExists(MapperS.of(mASTransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg2()))).getOrDefault(false)) {
						ifThenElseResult0 = areEqual(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()), MapperS.of(PaymentType4Code.UFRO), CardinalityOperator.All);
					} else {
						ifThenElseResult0 = ComparisonResult.successEmptyOperand("");
					}
					final ComparisonResult ifThenElseResult1;
					if (notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<BigDecimal>map("getAmount", otherPaymentReport -> otherPaymentReport.getAmount()).resultCount()), CardinalityOperator.Any).or(notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<ISOCurrencyCodeEnum>map("getCurrency", otherPaymentReport -> otherPaymentReport.getCurrency()).resultCount()), CardinalityOperator.Any)).or(notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<Date>map("getDate", otherPaymentReport -> otherPaymentReport.getDate()).resultCount()), CardinalityOperator.Any)).or(notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getPayer", otherPaymentReport -> otherPaymentReport.getPayer()).resultCount()), CardinalityOperator.Any)).or(notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver()).resultCount()), CardinalityOperator.Any)).getOrDefault(false)) {
						ifThenElseResult1 = ComparisonResult.of(MapperS.of(false));
					} else {
						ifThenElseResult1 = ComparisonResult.successEmptyOperand("");
					}
					return exists(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType())).and(ifThenElseResult0).and(ifThenElseResult1);
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0127_03 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
