package drr.regulation.mas.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.OtherPaymentReport;
import iso20022.auth030.mas.PaymentType4Code;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0132_01")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0132_01.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0132_01 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0132_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string, ActionTypeEnum -> TERM to-string ] any = actionType and otherPayment -> amount exists and otherPayment -> amount all <> 0 then otherPayment -> receiver exists and otherPayment -> payer <> otherPayment -> receiver and (if otherPayment -> receiver count <> otherPayment -> amount count or otherPayment -> receiver count <> otherPayment -> paymentType count or otherPayment -> paymentType count <> otherPayment -> date count or otherPayment -> receiver count <> otherPayment -> currency count or otherPayment -> receiver count <> otherPayment -> payer count then False)";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0132_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).and(exists(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<BigDecimal>map("getAmount", otherPaymentReport -> otherPaymentReport.getAmount()))).and(notEqual(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<BigDecimal>map("getAmount", otherPaymentReport -> otherPaymentReport.getAmount()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All)).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult;
					if (notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<BigDecimal>map("getAmount", otherPaymentReport -> otherPaymentReport.getAmount()).resultCount()), CardinalityOperator.Any).or(notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), CardinalityOperator.Any)).or(notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<Date>map("getDate", otherPaymentReport -> otherPaymentReport.getDate()).resultCount()), CardinalityOperator.Any)).or(notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<ISOCurrencyCodeEnum>map("getCurrency", otherPaymentReport -> otherPaymentReport.getCurrency()).resultCount()), CardinalityOperator.Any)).or(notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getPayer", otherPaymentReport -> otherPaymentReport.getPayer()).resultCount()), CardinalityOperator.Any)).getOrDefault(false)) {
						ifThenElseResult = ComparisonResult.of(MapperS.of(false));
					} else {
						ifThenElseResult = ComparisonResult.successEmptyOperand("");
					}
					return exists(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver())).and(notEqual(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getPayer", otherPaymentReport -> otherPaymentReport.getPayer()), MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver()), CardinalityOperator.Any)).and(ifThenElseResult);
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0132_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
