package drr.regulation.techsprint.g20.mas.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.techsprint.g20.mas.MASSFATransactionReport;
import drr.regulation.techsprint.g20.mas.validation.MASSFATransactionReportTypeFormatValidator;
import drr.regulation.techsprint.g20.mas.validation.MASSFATransactionReportValidator;
import drr.regulation.techsprint.g20.mas.validation.exists.MASSFATransactionReportOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 0.0.0
 */
@RosettaMeta(model=MASSFATransactionReport.class)
public class MASSFATransactionReportMeta implements RosettaMetaData<MASSFATransactionReport> {

	@Override
	public List<Validator<? super MASSFATransactionReport>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super MASSFATransactionReport, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super MASSFATransactionReport> validator(ValidatorFactory factory) {
		return factory.<MASSFATransactionReport>create(MASSFATransactionReportValidator.class);
	}

	@Override
	public Validator<? super MASSFATransactionReport> typeFormatValidator(ValidatorFactory factory) {
		return factory.<MASSFATransactionReport>create(MASSFATransactionReportTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super MASSFATransactionReport> validator() {
		return new MASSFATransactionReportValidator();
	}

	@Deprecated
	@Override
	public Validator<? super MASSFATransactionReport> typeFormatValidator() {
		return new MASSFATransactionReportTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super MASSFATransactionReport, Set<String>> onlyExistsValidator() {
		return new MASSFATransactionReportOnlyExistsValidator();
	}
}
