package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.math.Quantity;
import cdm.base.math.UnitType;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(InterestRateNotionalCurrencyLeg1Rule.InterestRateNotionalCurrencyLeg1RuleDefault.class)
public abstract class InterestRateNotionalCurrencyLeg1Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FixedFloatLeg1Rule fixedFloatLeg1Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class InterestRateNotionalCurrencyLeg1RuleDefault extends InterestRateNotionalCurrencyLeg1Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<InterestRatePayout> thenArg0 = MapperS.of(fixedFloatLeg1Rule.evaluate(input));
			final MapperS<InterestRatePayout> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
			final FieldWithMetaString fieldWithMetaString = thenArg1
				.mapSingleToItem(item -> item.<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).<Quantity>map("getResolvedQuantity", resolvablePriceQuantity -> resolvablePriceQuantity.getResolvedQuantity()).<UnitType>map("getUnit", quantity -> quantity.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
