package drr.standards.iosco.cde.reports;

import cdm.base.math.UnitType;
import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;


@ImplementedBy(CDECommodityNotionalCurrencyRule.CDECommodityNotionalCurrencyRuleDefault.class)
public abstract class CDECommodityNotionalCurrencyRule implements ReportFunction<PriceSchedule, String> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(PriceSchedule input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(PriceSchedule input);

	public static class CDECommodityNotionalCurrencyRuleDefault extends CDECommodityNotionalCurrencyRule {
		@Override
		protected String doEvaluate(PriceSchedule input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, PriceSchedule input) {
			final FieldWithMetaString fieldWithMetaString = MapperS.of(input).<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
