package drr.standards.iosco.cde.reports;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.identifier.IdentifiedList;
import cdm.base.staticdata.identifier.Identifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.ArrayList;
import java.util.List;


@ImplementedBy(CDEPackageIdentifierRule.CDEPackageIdentifierRuleDefault.class)
public abstract class CDEPackageIdentifierRule implements ReportFunction<IdentifiedList, List<String>> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<String> evaluate(IdentifiedList input) {
		List<String> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<String> doEvaluate(IdentifiedList input);

	public static class CDEPackageIdentifierRuleDefault extends CDEPackageIdentifierRule {
		@Override
		protected List<String> doEvaluate(IdentifiedList input) {
			List<String> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<String> assignOutput(List<String> output, IdentifiedList input) {
			output = MapperS.of(input)
				.mapSingleToList(item -> item.<Identifier>map("getListId", identifiedList -> identifiedList.getListId()).<AssignedIdentifier>mapC("getAssignedIdentifier", identifier -> identifier.getAssignedIdentifier()).<FieldWithMetaString>map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier())).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti();
			
			return output;
		}
	}
}
