package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNotationString;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;


@ImplementedBy(CDEPackageTransactionPriceNotationRule.CDEPackageTransactionPriceNotationRuleDefault.class)
public abstract class CDEPackageTransactionPriceNotationRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPackageTransactionPriceNotationEnumRule cDEPackageTransactionPriceNotationEnumRule;
	@Inject protected GetNotationString getNotationString;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class CDEPackageTransactionPriceNotationRuleDefault extends CDEPackageTransactionPriceNotationRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<PriceNotationEnum> thenArg = MapperS.of(cDEPackageTransactionPriceNotationEnumRule.evaluate(input));
			output = MapperS.of(getNotationString.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
