package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNotationString;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;


@ImplementedBy(CDEPackageTransactionSpreadNotationRule.CDEPackageTransactionSpreadNotationRuleDefault.class)
public abstract class CDEPackageTransactionSpreadNotationRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPackageTransactionSpreadNotationEnumRule cDEPackageTransactionSpreadNotationEnumRule;
	@Inject protected GetNotationString getNotationString;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class CDEPackageTransactionSpreadNotationRuleDefault extends CDEPackageTransactionSpreadNotationRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<PriceNotationEnum> thenArg = MapperS.of(cDEPackageTransactionSpreadNotationEnumRule.evaluate(input));
			output = MapperS.of(getNotationString.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
