package drr.standards.iosco.cde.reports;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Contract_Price_Monetary;
import drr.regulation.common.functions.GetNotationEnum;
import drr.regulation.common.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.regulation.common.functions.PriceOfZeroCouponSwaps;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CDEPriceCurrencyRule.CDEPriceCurrencyRuleDefault.class)
public abstract class CDEPriceCurrencyRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPriceNotationRule cDEPriceNotationRule;
	@Inject protected Contract_Price_Monetary contract_Price_Monetary;
	@Inject protected GetNotationEnum getNotationEnum;
	@Inject protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
	@Inject protected PriceOfZeroCouponSwaps priceOfZeroCouponSwaps;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class CDEPriceCurrencyRuleDefault extends CDEPriceCurrencyRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> areEqual(MapperS.of(getNotationEnum.evaluate(cDEPriceNotationRule.evaluate(item.get()))), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).get());
			final Boolean _boolean = isFixedFloatZeroCouponSwapKnownAmount.evaluate(productForEvent.evaluate(thenArg0.get()));
			final MapperC<FieldWithMetaString> ifThenElseResult;
			if ((_boolean == null ? false : _boolean)) {
				final MapperC<NonNegativeQuantitySchedule> thenArg1 = MapperC.<NonNegativeQuantitySchedule>of(priceOfZeroCouponSwaps.evaluate(thenArg0.get()));
				ifThenElseResult = thenArg1
					.mapItem(item -> item.<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()));
			} else {
				ifThenElseResult = MapperC.<PriceSchedule>of(contract_Price_Monetary.evaluate(thenArg0.get()))
					.mapItem(item -> item.<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()));
			}
			final FieldWithMetaString fieldWithMetaString = MapperS.of(ifThenElseResult.get()).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
