package drr.standards.iosco.cde.reports;

import cdm.product.common.settlement.CashSettlementTerms;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.SettlementTypeEnum;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.SettlementTermsLeg2;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CDESettlementLocationLeg2Rule.CDESettlementLocationLeg2RuleDefault.class)
public abstract class CDESettlementLocationLeg2Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ProductForEvent productForEvent;
	@Inject protected SettlementTermsLeg2 settlementTermsLeg2;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class CDESettlementLocationLeg2RuleDefault extends CDESettlementLocationLeg2Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<Product> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<SettlementTerms> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(settlementTermsLeg2.evaluate(item.get())));
			output = thenArg1
				.mapSingleToItem(item -> {
					if (areEqual(item.<SettlementTypeEnum>map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), MapperS.of(SettlementTypeEnum.CASH), CardinalityOperator.All).or(exists(item.<CashSettlementTerms>mapC("getCashSettlementTerms", settlementTerms -> settlementTerms.getCashSettlementTerms()))).and(areEqual(item.<FieldWithMetaString>map("getSettlementCurrency", settlementTerms -> settlementTerms.getSettlementCurrency()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()), MapperS.of("CNH"), CardinalityOperator.All)).getOrDefault(false)) {
						return MapperS.of("HK");
					}
					return MapperS.<String>ofNull();
				}).get();
			
			return output;
		}
	}
}
