package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNotationString;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;


@ImplementedBy(CDESpreadLeg1NotationRule.CDESpreadLeg1NotationRuleDefault.class)
public abstract class CDESpreadLeg1NotationRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDESpreadLeg1NotationEnumRule cDESpreadLeg1NotationEnumRule;
	@Inject protected GetNotationString getNotationString;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class CDESpreadLeg1NotationRuleDefault extends CDESpreadLeg1NotationRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<PriceNotationEnum> thenArg = MapperS.of(cDESpreadLeg1NotationEnumRule.evaluate(input));
			output = MapperS.of(getNotationString.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
